Option Explicit

Const scriptName = "Toggle Image Summary"
Const scriptVer = "1.1.0"

'Enable/disable the image Summary page property handler
' Michael Miller - http://www.esglabs.com/ - 3/7/2003
'This script may be freely distributed or modified

Const qImageSummary = "The Image Summary Extension is currently "
Const qISEnabled = "enabled.  Turn it off?"
Const qISDisabled = "disabled.  Turn it on?"

Const regRoot = "HKCR\SystemFileAssociations\image\ShellEx\PropertyHandler\"
Const regValue = "{eb9b1153-3b57-4e68-959a-a3266bc3d7fe}"
Const regDataType = "REG_SZ"


Dim WSHShell
Dim errNum
Dim isEnabled, question

Set WSHShell = WScript.CreateObject("WScript.Shell")


' Get the current state of the property handler
Err.Clear
On Error Resume Next
Call WSHShell.RegRead(regRoot)
errNum = Err.Number
On Error Goto 0

isEnabled = (errNum = 0)

If isEnabled Then
    question = qImageSummary & qISEnabled
Else
    question = qImageSummary & qISDisabled
End If

' If they answer yes to the question...
If MsgBox(question, 4, scriptName) = 6 Then
    If isEnabled Then
        ' The key is there; delete it to turn off Preview.
        Call WSHShell.RegDelete(regRoot)
    Else
        ' since the key's not there, add it back to turn on Preview.
        Call WSHShell.RegWrite(regRoot, regValue, regDataType)
    End If
End If
